/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.t.TuvasaTheSunlitWatcher;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;

class TuvasaTheSunlitTriggeredAbility
extends SpellCastControllerTriggeredAbility {
    public TuvasaTheSunlitTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), StaticFilters.FILTER_SPELL_AN_ENCHANTMENT, false, SetTargetPointer.SPELL);
    }

    private TuvasaTheSunlitTriggeredAbility(TuvasaTheSunlitTriggeredAbility ability) {
        super((SpellCastControllerTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (super.checkTrigger(event, game)) {
            TuvasaTheSunlitWatcher watcher = (TuvasaTheSunlitWatcher)game.getState().getWatcher(TuvasaTheSunlitWatcher.class);
            return watcher != null && event.getTargetId().equals(watcher.getFirstEnchantmentThisTurn(this.getControllerId()));
        }
        return false;
    }

    public String getRule() {
        return "Whenever you cast your first enchantment spell each turn, draw a card.";
    }

    public TuvasaTheSunlitTriggeredAbility copy() {
        return new TuvasaTheSunlitTriggeredAbility(this);
    }
}

