/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TwoHeadedGiantEffect
extends OneShotEffect {
    TwoHeadedGiantEffect() {
        super(Outcome.Benefit);
        this.staticText = "flip two coins. If both coins come up heads, {this} gains double strike until end of turn. If both coins come up tails, {this} gains menace until end of turn";
    }

    private TwoHeadedGiantEffect(TwoHeadedGiantEffect effect) {
        super((OneShotEffect)effect);
    }

    public TwoHeadedGiantEffect copy() {
        return new TwoHeadedGiantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List flips = player.flipCoins(source, game, 2, false);
        if (flips.get(0) == flips.get(1)) {
            game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)((Boolean)flips.get(0) != false ? DoubleStrikeAbility.getInstance() : new MenaceAbility()), Duration.EndOfTurn), source);
        }
        return true;
    }
}

