/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TyphoonEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    TyphoonEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to each opponent equal to the number of Islands that player controls";
    }

    private TyphoonEffect(TyphoonEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player;
            if (playerId.equals(source.getControllerId()) || (player = game.getPlayer(playerId)) == null) continue;
            int amount = 0;
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(filter, playerId, game)) {
                ++amount;
            }
            if (amount <= 0) continue;
            player.damage(amount, source.getSourceId(), source, game);
        }
        return true;
    }

    public TyphoonEffect copy() {
        return new TyphoonEffect(this);
    }

    static {
        filter.add((Predicate)SubType.ISLAND.getPredicate());
    }
}

