/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TyrannizeEffect
extends OneShotEffect {
    TyrannizeEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player discards their hand unless they pay 7 life";
    }

    private TyrannizeEffect(TyrannizeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TyrannizeEffect copy() {
        return new TyrannizeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            PayLifeCost cost = new PayLifeCost(7);
            if (!(cost.canPay(source, source, player.getId(), game) && player.chooseUse(Outcome.LoseLife, "Pay 7 life?", source, game) && cost.pay(source, game, source, player.getId(), false, null))) {
                player.discard(player.getHand(), false, source, game);
            }
            return true;
        }
        return false;
    }
}

