/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class LookAtRandomCardEffect
extends OneShotEffect {
    LookAtRandomCardEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at a card at random in target player's hand";
    }

    private LookAtRandomCardEffect(LookAtRandomCardEffect effect) {
        super((OneShotEffect)effect);
    }

    public LookAtRandomCardEffect copy() {
        return new LookAtRandomCardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && targetPlayer != null && sourceObject != null) {
            if (!targetPlayer.getHand().isEmpty()) {
                CardsImpl randomCard = new CardsImpl();
                Card card = targetPlayer.getHand().getRandom(game);
                randomCard.add(card);
                controller.lookAtCards(sourceObject.getName(), (Cards)randomCard, game);
                game.informPlayer(targetPlayer, "The random card from your hand shown to " + controller.getName() + " is " + card.getName());
            }
            return true;
        }
        return false;
    }
}

