/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Collection;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class UginEyeOfTheStormsEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterNonlandCard("colorless nonland cards");

    UginEyeOfTheStormsEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for any number of colorless nonland cards, exile them, then shuffle. Until end of turn, you may cast those cards without paying their mana costs";
    }

    private UginEyeOfTheStormsEffect(UginEyeOfTheStormsEffect effect) {
        super((OneShotEffect)effect);
    }

    public UginEyeOfTheStormsEffect copy() {
        return new UginEyeOfTheStormsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, Integer.MAX_VALUE, filter);
        player.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        cards.retainZone(Zone.LIBRARY, game);
        if (!cards.isEmpty()) {
            PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Set)cards.getCards(game), (TargetController)TargetController.YOU, (Duration)Duration.EndOfTurn, (boolean)true, (boolean)false, (boolean)true);
        }
        player.shuffleLibrary(source, game);
        return true;
    }

    static {
        filter.add((Predicate)ColorlessPredicate.instance);
    }
}

