/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class UlamogExileLibraryEffect
extends OneShotEffect {
    UlamogExileLibraryEffect() {
        super(Outcome.Exile);
        this.staticText = "defending player exiles the top twenty cards of their library";
    }

    private UlamogExileLibraryEffect(UlamogExileLibraryEffect effect) {
        super((OneShotEffect)effect);
    }

    public UlamogExileLibraryEffect copy() {
        return new UlamogExileLibraryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player defender = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (defender != null) {
            defender.moveCards(defender.getLibrary().getTopCards(game, 20), Zone.EXILED, source, game);
            return true;
        }
        return false;
    }
}

