/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.AnnihilatorAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class UlamogTheDefilerContinuousAbility
extends ContinuousEffectImpl {
    private Ability ability;
    private int lastAmount;

    UlamogTheDefilerContinuousAbility() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has annihilator X, where X is the number of +1/+1 counters on it";
        this.addDependencyType(DependencyType.AddingAbility);
        this.ability = new AnnihilatorAbility(0);
        this.lastAmount = 0;
    }

    private UlamogTheDefilerContinuousAbility(UlamogTheDefilerContinuousAbility effect) {
        super((ContinuousEffectImpl)effect);
        this.ability = effect.ability.copy();
        this.ability.newId();
        this.lastAmount = effect.lastAmount;
    }

    public void init(Ability source, Game game) {
        Permanent permanent;
        super.init(source, game);
        if (this.getAffectedObjectsSet() && (permanent = game.getPermanentEntering(source.getSourceId())) != null) {
            this.affectedObjectList.add(new MageObjectReference(source.getSourceId(), game.getState().getZoneChangeCounter(source.getSourceId()) + 1, game));
        }
    }

    public UlamogTheDefilerContinuousAbility copy() {
        return new UlamogTheDefilerContinuousAbility(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getAffectedObjectsSet() ? ((MageObjectReference)this.affectedObjectList.get(0)).getPermanent(game) : game.getPermanent(source.getSourceId());
        if (permanent != null) {
            int amount = permanent.getCounters(game).getCount(CounterType.P1P1);
            if (amount != this.lastAmount) {
                this.ability = new AnnihilatorAbility(amount);
                this.lastAmount = amount;
            }
            permanent.addAbility(this.ability, source.getSourceId(), game);
        }
        return true;
    }
}

