/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;

class UlamogsNullifierEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("cards your opponents own from exile");

    public UlamogsNullifierEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put two cards your opponents own from exile into their owners' graveyards. If you do, counter target spell.";
    }

    private UlamogsNullifierEffect(UlamogsNullifierEffect effect) {
        super((OneShotEffect)effect);
    }

    public UlamogsNullifierEffect copy() {
        return new UlamogsNullifierEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInExile target;
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = game.getStack().getSpell(source.getFirstTarget());
        if (controller != null && spell != null && (target = new TargetCardInExile(2, 2, filter)).canChoose(source.getControllerId(), source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game)) {
            CardsImpl cardsToGraveyard = new CardsImpl((Collection)target.getTargets());
            controller.moveCards((Cards)cardsToGraveyard, Zone.GRAVEYARD, source, game);
            game.getStack().counter(source.getFirstTarget(), source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getOwnerPredicate());
    }
}

