/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.condition.common.AddendumCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.effects.common.counter.AddCountersAllEffect;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;

class UnbreakableFormationEffect
extends OneShotEffect {
    UnbreakableFormationEffect() {
        super(Outcome.Benefit);
        this.staticText = "<br><i>Addendum</i> &mdash; If you cast this spell during your main phase, put a +1/+1 counter on each of those creatures and they gain vigilance until end of turn.";
    }

    private UnbreakableFormationEffect(UnbreakableFormationEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnbreakableFormationEffect copy() {
        return new UnbreakableFormationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!AddendumCondition.instance.apply(game, source)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE), source);
        return new AddCountersAllEffect(CounterType.P1P1.createInstance(), (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).apply(game, source);
    }
}

