/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Objects;
import java.util.UUID;
import mage.ConditionalMana;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.cards.u.UnclaimedTerritoryConditionalMana;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

class UnclaimedTerritoryManaBuilder
extends ConditionalManaBuilder {
    SubType creatureType;

    UnclaimedTerritoryManaBuilder() {
    }

    public ConditionalManaBuilder setMana(Mana mana, Ability source, Game game) {
        SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
        if (subType != null) {
            this.creatureType = subType;
        }
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null && mana.getAny() == 0) {
            game.informPlayers(controller.getLogName() + " produces " + mana.toString() + " with " + sourceObject.getLogName() + " (can only be spent to cast creatures of type " + this.creatureType + ")");
        }
        return super.setMana(mana, source, game);
    }

    public ConditionalMana build(Object ... options) {
        return new UnclaimedTerritoryConditionalMana((Mana)this.mana, this.creatureType);
    }

    public String getRule() {
        return "Spend this mana only to cast a creature spell of the chosen type";
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.creatureType);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return this.creatureType == ((UnclaimedTerritoryManaBuilder)((Object)obj)).creatureType;
    }
}

