/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class UnctusGrandMetatectEffect
extends ContinuousEffectImpl {
    UnctusGrandMetatectEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "until end of turn, target creature you control becomes a blue artifact in addition to its other colors and types";
    }

    private UnctusGrandMetatectEffect(UnctusGrandMetatectEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public UnctusGrandMetatectEffect copy() {
        return new UnctusGrandMetatectEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.addCardType(game, new CardType[]{CardType.ARTIFACT});
                return true;
            }
            case ColorChangingEffects_5: {
                permanent.getColor(game).setBlue(true);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case ColorChangingEffects_5: {
                return true;
            }
        }
        return false;
    }
}

