/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class UnderTheSkinEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterPermanentCard("permanent card from your graveyard");

    UnderTheSkinEffect() {
        super(Outcome.Benefit);
        this.concatBy("<br>");
        this.staticText = "You may return a permanent card from your graveyard to your hand.";
    }

    private UnderTheSkinEffect(UnderTheSkinEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnderTheSkinEffect copy() {
        return new UnderTheSkinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, filter, true);
        player.choose(Outcome.ReturnToHand, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        return player.moveCards(card, Zone.HAND, source, game);
    }
}

