/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class UndercityInformerEffect
extends OneShotEffect {
    UndercityInformerEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Target player reveals cards from the top of their library until they reveal a land card, then puts those cards into their graveyard";
    }

    private UndercityInformerEffect(UndercityInformerEffect effect) {
        super((OneShotEffect)effect);
    }

    public UndercityInformerEffect copy() {
        return new UndercityInformerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (!card.isLand(game)) continue;
            break;
        }
        player.revealCards(source, (Cards)cards, game);
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        return true;
    }
}

