/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UnderdarkRiftEffect
extends OneShotEffect {
    UnderdarkRiftEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a d10. Put target artifact, creature, or planeswalker into its owner's library just beneath the top X cards of that library, where X is the result";
    }

    private UnderdarkRiftEffect(UnderdarkRiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnderdarkRiftEffect copy() {
        return new UnderdarkRiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 10);
        player.putCardOnTopXOfLibrary((Card)permanent, game, source, result + 1, true);
        return true;
    }
}

