/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.cards.u.AtBeginningOfUntapDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class UndiscoveredParadiseEffect
extends OneShotEffect {
    UndiscoveredParadiseEffect() {
        super(Outcome.Neutral);
        this.staticText = "During your next untap step, as you untap your permanents, return {this} to its owner's hand";
    }

    private UndiscoveredParadiseEffect(UndiscoveredParadiseEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            ReturnToHandTargetEffect effect = new ReturnToHandTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtBeginningOfUntapDelayedTriggeredAbility((Effect)effect), source);
            return true;
        }
        return false;
    }

    public UndiscoveredParadiseEffect copy() {
        return new UndiscoveredParadiseEffect(this);
    }
}

