/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class UnexplainedAbsenceEffect
extends OneShotEffect {
    UnexplainedAbsenceEffect() {
        super(Outcome.Neutral);
    }

    private UnexplainedAbsenceEffect(UnexplainedAbsenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnexplainedAbsenceEffect copy() {
        return new UnexplainedAbsenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Set permanents = source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        HashSet<UUID> controllers = new HashSet<UUID>();
        for (Permanent permanent : permanents) {
            Player effectedController = game.getPlayer(permanent.getControllerId());
            if (effectedController == null) continue;
            controllers.add(effectedController.getId());
        }
        controller.moveCards(permanents, Zone.EXILED, source, game);
        for (UUID controllerId : controllers) {
            Player player = game.getPlayer(controllerId);
            ManifestEffect.doManifestCards((Game)game, (Ability)source, (Player)player, (Set)player.getLibrary().getTopCards(game, 1), (boolean)true);
        }
        return true;
    }
}

