/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.keyword.CyclingAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.players.Player;

class UnpredictableCycloneReplacementEffect
extends ReplacementEffectImpl {
    UnpredictableCycloneReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a cycling ability of another nonland card would cause you to draw a card, instead exile cards from the top of your library until you exile a card that shares a card type with the cycled card. You may cast that card without paying its mana cost. Then put the exiled cards that weren't cast this way on the bottom of your library in a random order.";
    }

    private UnpredictableCycloneReplacementEffect(UnpredictableCycloneReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public UnpredictableCycloneReplacementEffect copy() {
        return new UnpredictableCycloneReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (player == null || stackObject == null) {
            return false;
        }
        Card sourceCard = game.getCard(stackObject.getSourceId());
        if (sourceCard == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Card toCast = null;
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (!card.getCardType(game).stream().anyMatch(sourceCard.getCardType(game)::contains)) continue;
            toCast = card;
            break;
        }
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        if (toCast != null && player.chooseUse(this.outcome, "Cast the exiled card?", source, game)) {
            game.getState().setValue("PlayFromNotOwnHandZone" + toCast.getId(), (Object)Boolean.TRUE);
            Boolean cardWasCast = player.cast(player.chooseAbilityForCast(toCast, game, true), game, true, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + toCast.getId(), null);
            if (cardWasCast.booleanValue()) {
                cards.remove(toCast);
            }
        }
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getPlayerId().equals(source.getControllerId())) {
            return false;
        }
        Player player = game.getPlayer(event.getPlayerId());
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (player == null || stackObject == null || stackObject.getStackAbility() == null || !(stackObject.getStackAbility() instanceof CyclingAbility)) {
            return false;
        }
        Card sourceCard = game.getCard(stackObject.getSourceId());
        return sourceCard != null && !sourceCard.isLand(game);
    }
}

