/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.ZombieToken;
import mage.players.Player;

class UnscytheEffect
extends OneShotEffect {
    UnscytheEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "exile that card. If you do, create a 2/2 black Zombie creature token";
    }

    private UnscytheEffect(UnscytheEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnscytheEffect copy() {
        return new UnscytheEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || card == null) {
            return false;
        }
        if (game.getState().getZone(card.getId()) == Zone.GRAVEYARD && controller.moveCardToExileWithInfo(card, null, "", source, game, Zone.GRAVEYARD, true)) {
            return new ZombieToken().putOntoBattlefield(1, game, source, source.getControllerId());
        }
        return false;
    }
}

