/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldAllTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.u.UnstableShapeshifter;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class UnstableShapeshifterEffect
extends OneShotEffect {
    UnstableShapeshifterEffect() {
        super(Outcome.Copy);
        this.staticText = "{this} becomes a copy of that creature, except it has this ability";
    }

    private UnstableShapeshifterEffect(UnstableShapeshifterEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnstableShapeshifterEffect copy() {
        return new UnstableShapeshifterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Permanent targetCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (targetCreature != null && permanent != null) {
            Permanent blueprintPermanent = game.copyPermanent(Duration.Custom, targetCreature, permanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
            blueprintPermanent.addAbility((Ability)new EntersBattlefieldAllTriggeredAbility(Zone.BATTLEFIELD, (Effect)new UnstableShapeshifterEffect(), (FilterPermanent)UnstableShapeshifter.filterAnotherCreature, false, SetTargetPointer.PERMANENT), source.getSourceId(), game);
            return true;
        }
        return false;
    }
}

