/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestDreadEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UnwantedRemakeEffect
extends OneShotEffect {
    UnwantedRemakeEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy target creature. Its controller manifests dread";
    }

    private UnwantedRemakeEffect(UnwantedRemakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public UnwantedRemakeEffect copy() {
        return new UnwantedRemakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        permanent.destroy(source, game);
        if (player != null) {
            game.processAction();
            ManifestDreadEffect.doManifestDread((Player)player, (Ability)source, (Game)game);
        }
        return true;
    }
}

