/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.ManaPool;
import mage.players.Player;

class UpwellingRuleEffect
extends ContinuousEffectImpl {
    UpwellingRuleEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Players don't lose unspent mana as steps and phases end";
    }

    private UpwellingRuleEffect(UpwellingRuleEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public UpwellingRuleEffect copy() {
        return new UpwellingRuleEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                ManaPool pool = player.getManaPool();
                pool.addDoNotEmptyManaType(ManaType.WHITE);
                pool.addDoNotEmptyManaType(ManaType.GREEN);
                pool.addDoNotEmptyManaType(ManaType.BLUE);
                pool.addDoNotEmptyManaType(ManaType.RED);
                pool.addDoNotEmptyManaType(ManaType.BLACK);
                pool.addDoNotEmptyManaType(ManaType.COLORLESS);
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

