/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class UrbanBurgeoningUntapEffect
extends ContinuousEffectImpl {
    UrbanBurgeoningUntapEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Untap this land during each other player's untap step";
    }

    private UrbanBurgeoningUntapEffect(UrbanBurgeoningUntapEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public UrbanBurgeoningUntapEffect copy() {
        return new UrbanBurgeoningUntapEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        boolean applied = Boolean.TRUE.equals(game.getState().getValue(source.getSourceId() + "applied"));
        if (!applied && layer == Layer.RulesEffects) {
            if (!game.isActivePlayer(source.getControllerId()) && game.getTurnStepType() == PhaseStep.UNTAP) {
                game.getState().setValue(source.getSourceId() + "applied", (Object)true);
                Permanent land = game.getPermanent(source.getSourceId());
                boolean untap = true;
                for (RestrictionEffect effect : game.getContinuousEffects().getApplicableRestrictionEffects(land, game).keySet()) {
                    untap &= effect.canBeUntapped(land, source, game, true);
                }
                if (untap) {
                    land.untap(game);
                }
            }
        } else if (applied && layer == Layer.RulesEffects && game.getTurnStepType() == PhaseStep.END_TURN) {
            game.getState().setValue(source.getSourceId() + "applied", (Object)false);
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

