/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.LoseAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.SwampwalkAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class UrborgEffect
extends OneShotEffect {
    UrborgEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature loses first strike or swampwalk until end of turn.";
    }

    private UrborgEffect(UrborgEffect effect) {
        super((OneShotEffect)effect);
    }

    public UrborgEffect copy() {
        return new UrborgEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player == null || permanent == null) {
            return false;
        }
        Object ability = player.chooseUse(Outcome.UnboostCreature, "Which ability should be lost?", null, "First Strike", "Swampwalk", source, game) ? FirstStrikeAbility.getInstance() : new SwampwalkAbility();
        LoseAbilityTargetEffect effect = new LoseAbilityTargetEffect((Ability)ability, Duration.EndOfTurn);
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }
}

