/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.LimitedTimesPerTurnActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class UrsineChampion
extends CardImpl {
    public UrsineChampion(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{G}");
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.BERSERKER);
        this.power = new MageInt(2);
        this.toughness = new MageInt(2);
        LimitedTimesPerTurnActivatedAbility ability = new LimitedTimesPerTurnActivatedAbility(Zone.BATTLEFIELD, (Effect)new BoostSourceEffect(3, 3, Duration.EndOfTurn).setText("{this} gets +3/+3"), (Cost)new ManaCostsImpl("{5}{G}"));
        ability.addEffect((Effect)new UrsineChampionEffect());
        this.addAbility((Ability)ability);
    }

    private UrsineChampion(UrsineChampion card) {
        super((CardImpl)card);
    }

    public UrsineChampion copy() {
        return new UrsineChampion(this);
    }

    private static class UrsineChampionEffect
    extends ContinuousEffectImpl {
        private UrsineChampionEffect() {
            super(Duration.EndOfTurn, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.BecomeCreature);
            this.staticText = "and becomes a Bear Berserker until end of turn";
        }

        private UrsineChampionEffect(UrsineChampionEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public UrsineChampionEffect copy() {
            return new UrsineChampionEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Permanent permanent = game.getPermanent(source.getSourceId());
            if (permanent == null) {
                return false;
            }
            permanent.removeAllCreatureTypes(game);
            permanent.addSubType(game, new SubType[]{SubType.BEAR, SubType.BERSERKER});
            return true;
        }
    }
}

