/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class UrzasArmorEffect
extends PreventionEffectImpl {
    UrzasArmorEffect() {
        super(Duration.WhileOnBattlefield, 1, false, false);
        this.staticText = "If a source would deal damage to you, prevent 1 of that damage";
    }

    private UrzasArmorEffect(UrzasArmorEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(source.getControllerId())) {
            return super.applies(event, source, game);
        }
        return false;
    }

    public UrzasArmorEffect copy() {
        return new UrzasArmorEffect(this);
    }
}

