/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class UrzasEngineEffect
extends OneShotEffect {
    UrzasEngineEffect() {
        super(Outcome.AddAbility);
        this.staticText = "Attacking creatures banded with {this} gain trample until end of turn";
    }

    private UrzasEngineEffect(UrzasEngineEffect effect) {
        super((OneShotEffect)effect);
    }

    public UrzasEngineEffect copy() {
        return new UrzasEngineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null) {
            for (UUID bandedId : sourcePermanent.getBandedCards()) {
                Permanent banded = game.getPermanent(bandedId);
                if (banded == null || !banded.isAttacking() || banded.getBandedCards() == null || !banded.getBandedCards().contains(sourcePermanent.getId())) continue;
                GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn);
                effect.setTargetPointer((TargetPointer)new FixedTarget(bandedId, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

