/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SagaAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.abilities.mana.ColorlessManaAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.u.UrzasSagaPredicate;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SagaChapter;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.game.permanent.token.KarnConstructToken;
import mage.game.permanent.token.Token;
import mage.target.common.TargetCardInLibrary;

public final class UrzasSaga
extends CardImpl {
    private static final FilterCard filter = new FilterArtifactCard("artifact card with mana cost {0} or {1}");

    public UrzasSaga(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT, CardType.LAND}, "");
        this.subtype.add((Object)SubType.URZAS);
        this.subtype.add((Object)SubType.SAGA);
        SagaAbility sagaAbility = new SagaAbility((Card)this);
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_I, new Effect[]{new GainAbilitySourceEffect((Ability)new ColorlessManaAbility(), Duration.Custom).setText("{this} gains \"{T}: Add {C}.\"")});
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new CreateTokenEffect((Token)new KarnConstructToken()), (Cost)new GenericManaCost(2));
        ability.addCost((Cost)new TapSourceCost());
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_II, new Effect[]{new GainAbilitySourceEffect((Ability)ability, Duration.Custom).setText("{this} gains \"{2}, {T}: Create a 0/0 colorless Construct artifact creature token with 'This creature gets +1/+1 for each artifact you control.'\"")});
        sagaAbility.addChapterEffect((Card)this, SagaChapter.CHAPTER_III, new Effect[]{new SearchLibraryPutInPlayEffect(new TargetCardInLibrary(filter))});
        this.addAbility((Ability)sagaAbility);
    }

    private UrzasSaga(UrzasSaga card) {
        super((CardImpl)card);
    }

    public UrzasSaga copy() {
        return new UrzasSaga(this);
    }

    static {
        filter.add((Predicate)UrzasSagaPredicate.instance);
    }
}

