/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.u;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.u.UvildaDeanOfPerfectionGainAbilityEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class UvildaDeanOfPerfectionEffect
extends OneShotEffect {
    UvildaDeanOfPerfectionEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile an instant or sorcery card from your hand and put three hone counters on it. It gains \"At the beginning of your upkeep, if this card is exiled, remove a hone counter from it\" and \"When the last hone counter is removed from this card, if it's exiled, you may cast it. It costs {4} less to cast this way.\"";
    }

    private UvildaDeanOfPerfectionEffect(UvildaDeanOfPerfectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public UvildaDeanOfPerfectionEffect copy() {
        return new UvildaDeanOfPerfectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().count((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, game) < 1) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (game.getState().getZone(card.getId()) != Zone.EXILED) {
            return false;
        }
        card.addCounters(CounterType.HONE.createInstance(3), source.getControllerId(), source, game);
        game.addEffect((ContinuousEffect)new UvildaDeanOfPerfectionGainAbilityEffect(card, game), source);
        return true;
    }
}

