/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ExileTargetArtifactOrCreatureEffect
extends OneShotEffect {
    ExileTargetArtifactOrCreatureEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile target artifact or creature";
    }

    private ExileTargetArtifactOrCreatureEffect(ExileTargetArtifactOrCreatureEffect effect) {
        super((OneShotEffect)effect);
    }

    public ExileTargetArtifactOrCreatureEffect copy() {
        return new ExileTargetArtifactOrCreatureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreatureOrArtifact;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject Tibalt = source.getSourceObject(game);
        UUID exileId = CardUtil.getExileZoneId((String)source.getSourceId().toString(), (Game)game);
        if (controller != null && Tibalt != null && (targetCreatureOrArtifact = game.getPermanent(source.getTargets().getFirstTarget())) != null) {
            controller.moveCardsToExile((Card)targetCreatureOrArtifact, source, game, true, exileId, Tibalt.getName());
            return true;
        }
        return false;
    }
}

