/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ExileTopCardEachPlayersLibrary
extends OneShotEffect {
    public ExileTopCardEachPlayersLibrary() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top card of each player's library";
    }

    private ExileTopCardEachPlayersLibrary(ExileTopCardEachPlayersLibrary effect) {
        super((OneShotEffect)effect);
    }

    public ExileTopCardEachPlayersLibrary copy() {
        return new ExileTopCardEachPlayersLibrary(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject Tibalt = source.getSourceObject(game);
        UUID exileId = CardUtil.getExileZoneId((String)source.getSourceId().toString(), (Game)game);
        LinkedHashSet<Card> cardsToExile = new LinkedHashSet<Card>();
        if (controller != null && Tibalt != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.getLibrary().hasCards()) continue;
                Card topCard = player.getLibrary().getFromTop(game);
                cardsToExile.add(topCard);
            }
            if (!cardsToExile.isEmpty()) {
                return controller.moveCardsToExile(cardsToExile, source, game, true, exileId, Tibalt.getName());
            }
        }
        return false;
    }
}

