/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.effects.common.CreateTokenTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SurvivorToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class OpponentCreateSurvivorTokenCost
extends CostImpl {
    public OpponentCreateSurvivorTokenCost() {
        this.text = "Have an opponent create a 1/1 red Survivor creature token";
    }

    private OpponentCreateSurvivorTokenCost(OpponentCreateSurvivorTokenCost cost) {
        super((CostImpl)cost);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Player controller = game.getPlayer(controllerId);
        return controller != null && !game.getOpponents(controllerId).isEmpty();
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player opponent;
        TargetOpponent target;
        Player controller = game.getPlayer(controllerId);
        if (controller != null && controller.chooseTarget(Outcome.Neutral, (Target)(target = new TargetOpponent()), ability, game) && (opponent = game.getPlayer(target.getFirstTarget())) != null) {
            CreateTokenTargetEffect effect = new CreateTokenTargetEffect((Token)new SurvivorToken());
            effect.setTargetPointer((TargetPointer)new FixedTarget(opponent.getId(), game));
            this.paid = effect.apply(game, ability);
        }
        return this.paid;
    }

    public OpponentCreateSurvivorTokenCost copy() {
        return new OpponentCreateSurvivorTokenCost(this);
    }
}

