/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DevourEffect;
import mage.abilities.keyword.DevourAbility;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum TwiceDevouredGoblins implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Permanent sourcePermanent = game.getPermanent(sourceAbility.getSourceId());
        if (sourcePermanent == null) {
            return 0;
        }
        for (Ability ability : sourcePermanent.getAbilities()) {
            if (!(ability instanceof DevourAbility)) continue;
            for (Effect abilityEffect : ability.getEffects()) {
                if (!(abilityEffect instanceof DevourEffect)) continue;
                DevourEffect devourEffect = (DevourEffect)abilityEffect;
                int amountGoblins = 0;
                for (Permanent permanent : devourEffect.getDevouredCreatures(game, sourcePermanent.getId())) {
                    if (!permanent.hasSubtype(SubType.GOBLIN, game)) continue;
                    ++amountGoblins;
                }
                return amountGoblins * 2;
            }
        }
        return 0;
    }

    public TwiceDevouredGoblins copy() {
        return instance;
    }

    public String toString() {
        return "";
    }

    public String getMessage() {
        return "twice the number of Goblins it devoured";
    }
}

