/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CounterUnlessPaysEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.TargetSpell;

public final class VadersCommand
extends CardImpl {
    private static final FilterPermanent filterPlaneswalker = new FilterPermanent("planeswalker");
    private static final FilterCreaturePermanent filterNonArtifact = new FilterCreaturePermanent("nonartifact creature");

    public VadersCommand(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{B}{B}");
        this.getSpellAbility().getModes().setMinModes(2);
        this.getSpellAbility().getModes().setMaxModes(2);
        this.getSpellAbility().addEffect((Effect)new CounterUnlessPaysEffect((Cost)new PayLifeCost(5)).setText("Counter target spell unless its controller pays 5 life"));
        this.getSpellAbility().addTarget((Target)new TargetSpell());
        Mode mode = new Mode((Effect)new DestroyTargetEffect());
        mode.addTarget((Target)new TargetPermanent(filterPlaneswalker));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new DestroyTargetEffect());
        mode.addTarget((Target)new TargetPermanent((FilterPermanent)filterNonArtifact));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new GainLifeEffect(5).setText("Gain 5 life"));
        this.getSpellAbility().addMode(mode);
    }

    private VadersCommand(VadersCommand card) {
        super((CardImpl)card);
    }

    public VadersCommand copy() {
        return new VadersCommand(this);
    }

    static {
        filterPlaneswalker.add((Predicate)CardType.PLANESWALKER.getPredicate());
        filterNonArtifact.add(Predicates.not((Predicate)CardType.ARTIFACT.getPredicate()));
    }
}

