/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.common.replacement.GraveyardFromAnywhereExileReplacementEffect;
import mage.cards.Card;
import mage.cards.CardWithHalves;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class ValgavothTerrorEaterReplacementEffect
extends GraveyardFromAnywhereExileReplacementEffect {
    ValgavothTerrorEaterReplacementEffect() {
        super(StaticFilters.FILTER_CARD_A, false);
        this.staticText = "If a card you didn't control would be put into an opponent's graveyard from anywhere, exile it instead";
    }

    private ValgavothTerrorEaterReplacementEffect(ValgavothTerrorEaterReplacementEffect effect) {
        super((GraveyardFromAnywhereExileReplacementEffect)effect);
    }

    public ValgavothTerrorEaterReplacementEffect copy() {
        return new ValgavothTerrorEaterReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null) {
            return controller.moveCardsToExile((Card)permanent, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, (String)"(may be played using life)"));
        }
        Card card = game.getCard(event.getTargetId());
        if (card != null) {
            return controller.moveCardsToExile(card, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, (String)"(may be played using life)"));
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!super.applies(event, source, game)) {
            return false;
        }
        ZoneChangeEvent zce = (ZoneChangeEvent)event;
        UUID controllerId = source.getControllerId();
        Player controller = game.getPlayer(controllerId);
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(event.getTargetId());
        if (card == null) {
            return false;
        }
        if (zce.getFromZone() == Zone.BATTLEFIELD) {
            Permanent permanent = zce.getTarget();
            if (permanent == null || permanent.getControllerId().equals(controllerId)) {
                return false;
            }
        } else if (zce.getFromZone() == Zone.STACK) {
            CardWithHalves cwh;
            Spell spell = game.getSpellOrLKIStack(event.getTargetId());
            if (spell == null && card instanceof CardWithHalves && (spell = game.getSpellOrLKIStack((cwh = (CardWithHalves)card).getLeftHalfCard().getId())) == null) {
                spell = game.getSpellOrLKIStack(cwh.getRightHalfCard().getId());
            }
            if (spell == null || spell.getControllerId().equals(controllerId)) {
                return false;
            }
        }
        return controller.hasOpponent(card.getOwnerId(), game);
    }
}

