/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.keyword.CyclingAbility;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class ValiantRescuerWatcher
extends Watcher {
    private final Map<UUID, Map<UUID, Integer>> playerMap = new HashMap<UUID, Map<UUID, Integer>>();

    ValiantRescuerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ACTIVATED_ABILITY) {
            return;
        }
        StackObject item = game.getState().getStack().getFirstOrNull();
        if (item instanceof StackAbility && item.getStackAbility() instanceof CyclingAbility) {
            this.playerMap.computeIfAbsent(event.getPlayerId(), u -> new HashMap());
            this.playerMap.get(event.getPlayerId()).compute(event.getSourceId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.playerMap.clear();
    }

    boolean checkSpell(UUID playerId, UUID cardId) {
        if (!this.playerMap.containsKey(playerId)) {
            return true;
        }
        Map<UUID, Integer> cardMap = this.playerMap.get(playerId);
        return cardMap.keySet().stream().filter(uuid -> !uuid.equals(cardId)).mapToInt(cardMap::get).sum() < 1;
    }
}

