/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ValkyriesCallContinuousEffect
extends ContinuousEffectImpl {
    private final MageObjectReference mor;

    ValkyriesCallContinuousEffect(Card card, Game game) {
        super(Duration.Custom, Outcome.Neutral);
        this.mor = new MageObjectReference(card.getId(), card.getZoneChangeCounter(game) + 1, game);
    }

    private ValkyriesCallContinuousEffect(ValkyriesCallContinuousEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.mor = effect.mor;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent creature = this.mor.getPermanent(game);
        if (creature != null) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    creature.addSubType(game, new SubType[]{SubType.ANGEL});
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    creature.addAbility((Ability)FlyingAbility.getInstance(), source.getSourceId(), game);
                }
            }
            return true;
        }
        this.used = true;
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public ValkyriesCallContinuousEffect copy() {
        return new ValkyriesCallContinuousEffect(this);
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

