/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ValkyriesCallCounterEffect
extends ReplacementEffectImpl {
    private final MageObjectReference mor;

    ValkyriesCallCounterEffect(Card card, Game game) {
        super(Duration.EndOfStep, Outcome.BoostCreature);
        this.mor = new MageObjectReference((MageObject)card, game);
    }

    private ValkyriesCallCounterEffect(ValkyriesCallCounterEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.mor = effect.mor;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature != null && this.mor.refersTo((MageObject)creature, game)) {
            creature.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game, event.getAppliedEffects());
            this.discard();
        }
        return false;
    }

    public ValkyriesCallCounterEffect copy() {
        return new ValkyriesCallCounterEffect(this);
    }
}

