/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class ValleyFlamecallerEffect
extends ReplacementEffectImpl {
    ValleyFlamecallerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if a Lizard, Mouse, Otter, or Raccoon you control would deal damage to a permanent or player, it deals that much damage plus 1 instead";
    }

    private ValleyFlamecallerEffect(ValleyFlamecallerEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ValleyFlamecallerEffect copy() {
        return new ValleyFlamecallerEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && (permanent.hasSubtype(SubType.LIZARD, game) || permanent.hasSubtype(SubType.MOUSE, game) || permanent.hasSubtype(SubType.OTTER, game) || permanent.hasSubtype(SubType.RACCOON, game));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }
}

