/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.v.VanishIntoMemoryEntersBattlefieldEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class VanishIntoMemoryReturnFromExileEffect
extends OneShotEffect {
    VanishIntoMemoryReturnFromExileEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return that card to the battlefield under its owner's control";
    }

    private VanishIntoMemoryReturnFromExileEffect(VanishIntoMemoryReturnFromExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public VanishIntoMemoryReturnFromExileEffect copy() {
        return new VanishIntoMemoryReturnFromExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cards = new CardsImpl((Collection)this.getTargetPointer().getTargets(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet cardsToBattlefield = new HashSet();
            cardsToBattlefield.addAll(cards.getCards(game));
            VanishIntoMemoryEntersBattlefieldEffect effect = new VanishIntoMemoryEntersBattlefieldEffect();
            effect.setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game));
            game.addEffect((ContinuousEffect)effect, source);
            controller.moveCards(cardsToBattlefield, Zone.BATTLEFIELD, source, game, false, false, true, null);
        }
        return true;
    }
}

