/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VantressGargoyleAttackEffect
extends RestrictionEffect {
    VantressGargoyleAttackEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless defending player has seven or more cards in their graveyard";
    }

    private VantressGargoyleAttackEffect(VantressGargoyleAttackEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        Player player = game.getPlayerOrPlaneswalkerController(defenderId);
        return player != null && player.getGraveyard().size() > 6;
    }

    public VantressGargoyleAttackEffect copy() {
        return new VantressGargoyleAttackEffect(this);
    }
}

