/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.TargetPlayer;

class VassalsDutyPreventDamageTargetEffect
extends RedirectionEffect {
    VassalsDutyPreventDamageTargetEffect() {
        super(Duration.EndOfTurn, 1, RedirectionEffect.UsageType.ONE_USAGE_ABSOLUTE);
        this.staticText = "The next 1 damage that would be dealt to target legendary creature you control this turn is dealt to you instead";
    }

    private VassalsDutyPreventDamageTargetEffect(VassalsDutyPreventDamageTargetEffect effect) {
        super((RedirectionEffect)effect);
    }

    public VassalsDutyPreventDamageTargetEffect copy() {
        return new VassalsDutyPreventDamageTargetEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getTargetId().equals(this.getTargetPointer().getFirst(game, source))) {
            return false;
        }
        TargetPlayer target = new TargetPlayer();
        target.add(source.getControllerId(), game);
        this.redirectTarget = target;
        return true;
    }
}

