/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class VeilOfSummerWatcher
extends Watcher {
    private final Set<UUID> opponentsCastBlueBlackSpell = new HashSet<UUID>();

    VeilOfSummerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (GameEvent.EventType.SPELL_CAST == event.getType()) {
            Spell spell = game.getStack().getSpell(event.getTargetId());
            if (spell == null) {
                return;
            }
            if (spell.getColor(game).isBlack() || spell.getColor(game).isBlue()) {
                this.opponentsCastBlueBlackSpell.addAll(game.getOpponents(spell.getControllerId()));
            }
        }
    }

    public void reset() {
        super.reset();
        this.opponentsCastBlueBlackSpell.clear();
    }

    boolean opponentCastBlueBlackSpell(UUID playerId) {
        return this.opponentsCastBlueBlackSpell.contains(playerId);
    }
}

