/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.combat.CantBeBlockedAllEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;

class VeilingOddityTriggeredAbility
extends TriggeredAbilityImpl {
    public VeilingOddityTriggeredAbility() {
        super(Zone.EXILED, (Effect)new CantBeBlockedAllEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, Duration.EndOfTurn), false);
        this.setTriggerPhrase("When the last time counter is removed from {this} while it's exiled, ");
    }

    private VeilingOddityTriggeredAbility(VeilingOddityTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER_REMOVED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getTargetId().equals(this.getSourceId()) && event.getData().equals(CounterType.TIME.getName()) && game.getCard(event.getTargetId()).getCounters(game).getCount(CounterType.TIME) == 0;
    }

    public VeilingOddityTriggeredAbility copy() {
        return new VeilingOddityTriggeredAbility(this);
    }
}

