/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VengefulAncestorEffect
extends OneShotEffect {
    VengefulAncestorEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals 1 damage to its controller";
    }

    private VengefulAncestorEffect(VengefulAncestorEffect effect) {
        super((OneShotEffect)effect);
    }

    public VengefulAncestorEffect copy() {
        return new VengefulAncestorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = (Permanent)this.getValue("attacker");
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        return player.damage(1, permanent.getId(), source, game) > 0;
    }
}

