/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.common.PreventDamageToControllerEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class VengefulArchonEffect
extends PreventDamageToControllerEffect {
    VengefulArchonEffect() {
        super(Duration.EndOfTurn, false, true, (DynamicValue)GetXValue.instance);
        this.staticText = "Prevent the next X damage that would be dealt to you this turn. If damage is prevented this way, {this} deals that much damage to target player or planeswalker";
    }

    private VengefulArchonEffect(VengefulArchonEffect effect) {
        super((PreventDamageToControllerEffect)effect);
    }

    public VengefulArchonEffect copy() {
        return new VengefulArchonEffect(this);
    }

    protected PreventionEffectData preventDamageAction(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionEffectData = super.preventDamageAction(event, source, game);
        int damage = preventionEffectData.getPreventedDamage();
        if (damage > 0) {
            game.damagePlayerOrPermanent(source.getFirstTarget(), damage, source.getSourceId(), source, game, false, true);
        }
        return preventionEffectData;
    }
}

