/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VengefulStranglerEffect
extends OneShotEffect {
    VengefulStranglerEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return it to the battlefield transformed under your control attached to target creature or planeswalker an opponent controls";
    }

    private VengefulStranglerEffect(VengefulStranglerEffect effect) {
        super((OneShotEffect)effect);
    }

    public VengefulStranglerEffect copy() {
        return new VengefulStranglerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (controller == null || permanent == null || game.getState().getZone(source.getSourceId()) != Zone.GRAVEYARD) {
            return false;
        }
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        game.getState().setValue("EnterTransformed" + source.getSourceId(), (Object)Boolean.TRUE);
        game.getState().setValue("attachTo:" + source.getSourceId(), (Object)permanent);
        if (controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            permanent.addAttachment(card.getId(), source, game);
        }
        return true;
    }
}

