/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class VenomDeadlyDevourerEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.SYMBIOTE, "Symbiote");

    VenomDeadlyDevourerEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target creature card from a graveyard. When you do, put X +1/+1 counters on target Symbiote, where X is the exiled card's toughness";
    }

    private VenomDeadlyDevourerEffect(VenomDeadlyDevourerEffect effect) {
        super((OneShotEffect)effect);
    }

    public VenomDeadlyDevourerEffect copy() {
        return new VenomDeadlyDevourerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null || card == null) {
            return false;
        }
        int toughness = card.getToughness().getValue();
        player.moveCards(card, Zone.EXILED, source, game);
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance(toughness)), false);
        ability.addTarget((Target)new TargetPermanent(filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

