/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetOpponent;

class VerdantMasteryEffect
extends OneShotEffect {
    private final UUID alternativeCostOriginalID;

    VerdantMasteryEffect(UUID alternativeCostOriginalID) {
        super(Outcome.Detriment);
        this.staticText = "search your library for up to four basic land cards and reveal them. Put one of them onto the battlefield tapped under an opponent's control if the {3}{G} cost was paid. Put two of them onto the battlefield tapped under your control and the rest into your hand. Then shuffle";
        this.alternativeCostOriginalID = alternativeCostOriginalID;
    }

    private VerdantMasteryEffect(VerdantMasteryEffect effect) {
        super((OneShotEffect)effect);
        this.alternativeCostOriginalID = effect.alternativeCostOriginalID;
    }

    public VerdantMasteryEffect copy() {
        return new VerdantMasteryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, 4, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        player.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        player.revealCards(source, (Cards)cards, game);
        if (cards.isEmpty()) {
            player.shuffleLibrary(source, game);
            return true;
        }
        if (AlternativeCostSourceAbility.getActivatedStatus((Game)game, (Ability)source, (UUID)this.alternativeCostOriginalID, (boolean)false)) {
            TargetOpponent targetOpponent = new TargetOpponent(true);
            player.chooseTarget(Outcome.DrawCard, (Target)targetOpponent, source, game);
            Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
            if (opponent != null) {
                target = new TargetCardInLibrary(1, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
                target.setRequired(true);
                target.withChooseHint("to give to " + opponent.getName());
                player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
                Card card = game.getCard(target.getFirstTarget());
                opponent.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
            }
        }
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.LIBRARY);
        if (cards.isEmpty()) {
            player.shuffleLibrary(source, game);
            return true;
        }
        target = new TargetCardInLibrary(Math.min(cards.size(), 2), (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        target.setRequired(true);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.LIBRARY);
        player.moveCards((Cards)cards, Zone.HAND, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

