/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.v.VerdantSunsAvatarEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class VerdantSunsAvatarTriggeredAbility
extends TriggeredAbilityImpl {
    public VerdantSunsAvatarTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new VerdantSunsAvatarEffect(), false);
        this.setTriggerPhrase("Whenever {this} or another creature you control enters, ");
    }

    private VerdantSunsAvatarTriggeredAbility(VerdantSunsAvatarTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null || !permanent.isCreature(game) || !permanent.isControlledBy(this.controllerId)) {
            return false;
        }
        Effect effect = (Effect)this.getEffects().get(0);
        effect.setValue("lifeSource", (Object)event.getTargetId());
        effect.setValue("zoneChangeCounter", (Object)permanent.getZoneChangeCounter(game));
        return true;
    }

    public VerdantSunsAvatarTriggeredAbility copy() {
        return new VerdantSunsAvatarTriggeredAbility(this);
    }
}

